unit Main;

//      
// (Owner - SubComponent),     
//     ,   
//    .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls,
  TestForm;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Bevel1: TBevel;
    Memo1: TMemo;
    Label5: TLabel;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Label4: TLabel;
    ComboBox1: TComboBox;
    Button2: TButton;
    Button3: TButton;
    Label8: TLabel;
    Button5: TButton;
    BevelDyn1: TBevel;
    BevelDyn3: TBevel;
    BevelDyn2: TBevel;
    Label7: TLabel;
    ListBox2: TListBox;
    Edit1: TEdit;
    Button1: TButton;
    Label1: TLabel;
    TabSheet2: TTabSheet;
    Edit2: TEdit;
    ComboBox2: TComboBox;
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure ListBox2Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    procedure ComponentCreate();
    procedure ComponentFree();
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}



var ArrComp : array[0..2] of TComponent;

// =========================================================

type TControlClass = class of TControl;

//          
function  SeekComponent (RqOwner : TComponent; RqName : string): TComponent;
var Obtained : TComponent;
//     
procedure SeekComp(RqOwner  : TComponent; RqName : string;
               var Obtained : TComponent);
var Ind   : integer;
begin
 if Obtained <> nil then Exit;  //     ( )
 if RqOwner.ComponentCount > 0
 then begin
   //    
   //    
   for Ind := 0 to (RqOwner.ComponentCount - 1) do
   begin
     if RqOwner.Components[Ind].Name = RqName
     then begin
          //  ,  
          Obtained := RqOwner.Components[Ind];  Exit;
     end  //       
     else SeekComp(RqOwner.Components[Ind], RqName, Obtained);
   end;
 end;
end; // of procedure SeekComp
//  
begin
  Obtained := nil; //  
  SeekComp (RqOwner, RqName, Obtained);
  Result := Obtained;
end; // of function  SeekComponent


// =========================================================
function CreateControl(ControlClass  : TControlClass;
                       ParentControl : TWinControl;
                 const ControlName   : string;
                          X, Y, W, H : Integer): TControl;
begin
  Result := ControlClass.Create(ParentControl);
  with Result do
  begin
    Parent := ParentControl;
    Name := ControlName;
    SetBounds(X, Y, W, H);
    Visible := True;
  end;
end;

// =========================================================
//     
procedure EnumContainer(RqContainer  : TComponent; RqList : TListBox);
var Ind   : integer;
begin
 if Assigned(RqContainer)
 then begin
   if RqContainer.ComponentCount > 0
   then begin
     //    
     if not (RqContainer is TApplication)
     then begin
        RqList.Items.AddObject(RqContainer.GetNamePath, RqContainer);
     end;
     //    
     for Ind := 0 to (RqContainer.ComponentCount - 1) do
     begin
       //   
       if RqContainer.Components[Ind].ComponentCount > 0
       then begin
          //  
          EnumContainer(RqContainer.Components[Ind], RqList);
       end;
     end;
   end;
 end;
end; // of procedure EnumContainer

// =========================================================
//    
procedure EnumControls(RqContainer : TComponent; RqMemo : TMemo);
var Ind   : integer;
    Child : TObject;
begin
 if Assigned(RqContainer)
 then begin
   if RqContainer.ComponentCount > 0
   then begin
     RqMemo.Lines.Add('     : '
                     + RqContainer.GetNamePath);
     RqMemo.Lines.Add('  : '
                     + IntToStr(RqContainer.ComponentCount));
     RqMemo.Lines.Add('  : ');
     for Ind := 0 to (RqContainer.ComponentCount - 1) do
     begin
       Child := RqContainer.Components[Ind];
       RqMemo.Lines.Add((Child as TComponent).Name);
       if (Child as TComponent).ComponentCount >0
       then begin
          EnumControls((Child as TComponent), RqMemo);
       end;
     end;
   end;
 end;
end;

// =========================================================
procedure TForm1.ComponentCreate();
var Ind : integer;
begin
   Ind := ComboBox1.ItemIndex;
   case Ind of
   0 : begin
         if ArrComp[Ind] = nil
         then ArrComp[Ind] := CreateControl(TEdit, Form1,
                                           'DynEdit1',
                                           BevelDyn1.Left + 8,
                                           BevelDyn1.Top  + 4 ,
                                           BevelDyn1.Width  - 16,
                                           BevelDyn1.Height - 8);
         if ArrComp[Ind] <> nil
         then (ArrComp[Ind] as TEdit).Text := 'DynEdit1';
       end;
   1 : begin
         if ArrComp[Ind] = nil
         then ArrComp[Ind] := CreateControl(TEdit, Panel1,
                                           'DynEdit2',
                                           BevelDyn2.Left + 8,
                                           BevelDyn2.Top  + 4 ,
                                           BevelDyn2.Width  - 16,
                                           BevelDyn2.Height - 8);
         if ArrComp[Ind] <> nil
         then (ArrComp[Ind] as TEdit).Text := 'DynEdit2';
       end;
   2 : begin
         if ArrComp[Ind] = nil
         then ArrComp[Ind] := CreateControl(TEdit, PageControl1.Pages[0],
                                           'DynEdit3',
                                           BevelDyn3.Left + 8,
                                           BevelDyn3.Top  + 4 ,
                                           BevelDyn3.Width  - 16,
                                           BevelDyn3.Height - 8);
         if ArrComp[Ind] <> nil
         then (ArrComp[Ind] as TEdit).Text := 'DynEdit3';
       end;
    end;
end;

// =========================================================
procedure TForm1.ComponentFree();
var Ind : integer;
begin
   Ind := ComboBox1.ItemIndex;
   if (Ind >= 0) and (Ind < ComboBox1.Items.Count)
   then begin
     if ArrComp[Ind] <> nil
       then begin
          ArrComp[Ind].Free;
          ArrComp[Ind] := nil;
       end;
   end;
end;

// =========================================================
procedure TForm1.FormActivate(Sender: TObject);
begin
  ListBox2.Clear;
  EnumContainer(Application, ListBox2);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  ComponentCreate();
  ListBox2.Clear;
  EnumContainer(Application, ListBox2);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  ComponentFree();
  ListBox2.Clear;
  EnumContainer(Application, ListBox2);
end;

procedure TForm1.ListBox2Click(Sender: TObject);
var Ind : integer;
    RqComponent : TComponent;
begin
   if ListBox2.Count > 0
   then begin
     Ind := ListBox2.ItemIndex;
     if Ind >= 0
     then begin
       RqComponent := (ListBox2.Items.Objects[Ind] as TComponent);
       Memo1.Clear;
       Memo1.Lines.Add('');
       EnumControls(RqComponent, Memo1);
     end;
   end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
   Form2.Show;
   ListBox2.Clear;
   EnumContainer(Application, ListBox2);
end;

procedure TForm1.Button5Click(Sender: TObject);
var Obtained : TComponent;
begin
 if Edit1.Text <> ''
 then begin
   Memo1.Clear;
   Memo1.Lines.Add(' :');
   Obtained := SeekComponent((Application as TComponent), Edit1.Text);
   if Obtained = nil
   then Memo1.Lines.Add(' : ' + Edit1.Text + '  ')
   else begin
        Memo1.Lines.Add(' : ' +  Edit1.Text + ' ');
        Obtained := Obtained.Owner;
        Memo1.Lines.Add('  : ' + Obtained.Name);
   end;
 end;
end;


end.
